<?php
/*
 * Copyright (c) 2014 Mathieu Parent <sathieu@debian.org>
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

//namespace Pkgtools;

/**
* This class tests basic functionnality of \Pkgtools\Phppear\Source
*
* @copyright Copyright (c) 2014 Mathieu Parent <sathieu@debian.org>
* @author Mathieu Parent <sathieu@debian.org>
* @license Expat http://www.jclark.com/xml/copying.txt
*/
class PhppearSourceTest extends PHPUnit_Framework_TestCase {
    /**
     * @expectedException InvalidArgumentException
     * @expectedExceptionMessage package.xml not found
     */
    public function testFailedOpen() {
        // Open a directory without a package.xml
        $source = new \Pkgtools\Phppear\Source('testsuite/data');
    }

    public function testOpen() {
        // Open test package
        $source = new \Pkgtools\Phppear\Source('testsuite/data/pearpkg1');

        // Pass source to dependents tests
        return $source;
    }

    /**
     * @depends testOpen
     */
    public function testName($source) {
        $this->assertEquals('MyProject_Packages', $source->name);
    }

    /**
     * @depends testOpen
     */
    public function testChannel($source) {
        $this->assertEquals('pear.php.net', $source->channel);
    }

    /**
     * @depends testOpen
     */
    public function testSummary($source) {
        $this->assertEquals('this is a wrapper package for installing dependencies for MyProject.', $source->summary);
    }

    /**
     * @depends testOpen
     */
    public function testDescription($source) {
        $this->assertEquals('<Some random notes>', $source->description);
    }

    /**
     * @depends testOpen
     */
    public function testDependencies($source) {
        $wantedDeps = new \Pkgtools\Base\Dependencies();
        $wantedDeps[] = new \Pkgtools\Base\Dependency('require', '', 'php', '5.2.1', NULL);
        $wantedDeps[] = new \Pkgtools\Base\Dependency('require', 'pear-pear.horde.org', 'Horde_Alarm', '2.2.0', '3.0.0~alpha1');
        $wantedDeps[] = new \Pkgtools\Base\Dependency('recommend', 'pear-pecl.php.net', 'mysqli');
        $deps = $source->getDependencies();
        $this->assertEquals($wantedDeps, $deps);
    }
}
